library(readxl)
library(tidyverse)
library(tidyselect)
library(dplyr)
library(sjPlot)
library(ggplot2)
library(forecast)
library(fpp)
library(changepoint.np)
library(dtw)

df1 <- df_new1 %>%
  select(contains('phenotype'), Time) %>% 
  dplyr::mutate(TFEB_phosphorylated = rowSums(dplyr::across(contains("TFEB_phosphorylated"))))
# Reshape data frame
data_ggp <- data.frame(Iterations.steps = data$Time,                            
                        ActivityLevels.pobabilities = c(phenotype1,phenotype2),
                        Conditions = c(rep("phenotype1", nrow(data1)),
                                       rep("phenotype2", nrow(data1))))
ggp <- ggplot(data_ggp, aes(Iterations.steps, ActivityLevels.pobabilities, col = Conditions)) +    
  geom_line(size=1.1)+
  scale_x_continuous(breaks = seq(0, 5, 1)) +
  scale_y_continuous(breaks = seq(0, 1, .1)) 

save_plot("cohort.png", fig = ggp, width=60, height=30)
# check the change points in one time series data
changepoint.np::cpt.np(data$phenotype1)@cpts
#staging the phenotype based on change points
state <- window(data$phenotype,start =1, end = 18)
alignment1 <- dtw(state1,state2)
alignment1$distance
alignment1$normalizedDistanc